/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/


/*
 * $Log: rand.c,v $
 * Revision 1.9  2000/07/27 21:54:48  stig
 * Added argv, argc to diag commands; other misc cleanups for 1.41pre2
 *
 * Revision 1.8  2000/06/24 18:31:41  stig
 * 64-bit random number generator function (note - still not MT-safe
 *
 * Revision 1.7  2000/04/11 23:32:56  stig
 * Release 1.3.3 source base
 *
 * Revision 1.3  1999/07/26 07:42:23  stig
 * Numerous amendments and bugfixes in preparation for first release version
 *
 * Revision 1.2  1999/07/12 13:36:34  stig
 * Added API copyright header
 *
 * Revision 1.1  1999/03/29 21:27:53  stig
 * Folded in the debug monitor sources, introduced mechanism for mulit-platform
 * manufacturing diagnostics.
 *
 * Revision 1.1.1.1  1998/12/29 21:36:11  paradis
 * Initial CVS checkin
 *
 * Revision 1.2  1997/04/24  21:14:26  pbell
 * Cleaned up warnings
 *
 * Revision 1.1  1997/02/21  03:38:17  gries
 * Initial revision
 *
 */

#include "lib.h"

smp_mutex drandom_mutex = M_FREE;	/* advisory thing */
uint64 seed_cache[ MAX_CPUS ];		/* advisory thing */


static sl m = 971;
static sl ia = 11113;
static sl ib = 104322;
static sl irand = 4181;

/* STIG - I want a reproducible sequence from srandom.  By setting the internal
 * state to these initial (but unimportant) values, this is obtained */

const static sl m_orig = 971;
const static sl ia_orig = 11113;
const static sl ib_orig = 104322;

uint32 random( void )
{
    m = m + 13;
    ia = ia + 1913;
    ib = ib + 73939;
    if (m >= 9973) m = m - 9931L;
    if (ia >= 99991) ia = ia - 89989L;
    if (ib >= 224729) ib = ib - 224717L;
    irand= ((irand * m + ia + ib));
    return((uint32)((irand >> 4) % ((sl)RAND_MAX + 1)));
}

uint64 qrandom( void )
{
    uint64 val;

    val = (uint64)random() << 32;
    val |= random();

    return val;
}


int srandom( unsigned seed )
{
  irand = seed;
  m = m_orig;			/* STIG - reset internal state also */
  ia = ia_orig;			/* (no idea how this affects the randomness) */
  ib = ib_orig;
  return 0;
}
